********************************************************************************
* PROGRAMMER: DOS
* PROJECT:    EANNA 2023
* PURPOSE:    Indicador de Trabajo Infantil 2023
* LAST UPDATE:Diciembre 2024
* INPUT:      BASE EANNA 2023
********************************************************************************
		
***********************************************************************
* SECCION FORMATO: VARIABLE EDAD
***********************************************************************
gen 	edad_grupo=1 if inrange(edad_tramos,2,5)	//5 a 8
replace edad_grupo=2 if inrange(edad_tramos,6,11)	//9 a 14
replace edad_grupo=3 if inrange(edad_tramos,12,14)	//15 a 17
label variable edad_grupo "Grupo etario"
label define edad_grupo 1 "5-8" 2 "9-14" 3 "15-17" 
label values edad_grupo edad_grupo
***********************************************************************
* REVISION glosa 77 modulo Actividades Economicas: definiendo forma de trabajo y excepciones (9 a 17)
***********************************************************************
gen a77_o=.
foreach i in "EANNA_010084" "EANNA_010369" "EANNA_010414" "EANNA_01063" "EANNA_010632" "EANNA_010635" "EANNA_010672" "EANNA_010838" "EANNA_0111" "EANNA_011172" "EANNA_011476" "EANNA_01169" "EANNA_011750" "EANNA_011844" "EANNA_01201" "EANNA_012062" "EANNA_012574" "EANNA_012750" "EANNA_012944" "EANNA_013027" "EANNA_013231" "EANNA_013232" "EANNA_013299" "EANNA_013315" "EANNA_013445" "EANNA_013650" "EANNA_013653" "EANNA_013901" "EANNA_014028" "EANNA_014070" "EANNA_014196" "EANNA_014315" "EANNA_014356" "EANNA_01438" "EANNA_014674" "EANNA_014774" "EANNA_014783" "EANNA_014851" "EANNA_014881" "EANNA_014936" "EANNA_014989" "EANNA_015263" "EANNA_015314" "EANNA_015465" "EANNA_015670" "EANNA_015920" "EANNA_015961" "EANNA_015990" "EANNA_016029" "EANNA_016069" "EANNA_016101" "EANNA_01611" "EANNA_016203" "EANNA_016237" "EANNA_016253" "EANNA_016468" "EANNA_016931" "EANNA_017072" "EANNA_01722" "EANNA_017239" "EANNA_017291" "EANNA_01735" "EANNA_017528" "EANNA_017583" "EANNA_01780" "EANNA_01892" "EANNA_01916" "EANNA_01954" "EANNA_0197" "EANNA_02349" "EANNA_02673" "EANNA_02937" "EANNA_03126" "EANNA_03171" "EANNA_03210" "EANNA_03258" "EANNA_03319" "EANNA_0340" "EANNA_03404" "EANNA_03423" "EANNA_03425" "EANNA_03660" "EANNA_03877" "EANNA_04027" "EANNA_04095" "EANNA_04097" "EANNA_04127" "EANNA_04460" "EANNA_04485" "EANNA_04500" "EANNA_04516" "EANNA_04554" "EANNA_04573" "EANNA_0468" "EANNA_04757" "EANNA_04791" "EANNA_0485" "EANNA_05093" "EANNA_05369" "EANNA_05405" "EANNA_05548" "EANNA_05683" "EANNA_06" "EANNA_06157" "EANNA_06349" "EANNA_06487" "EANNA_06512" "EANNA_06579" "EANNA_06826" "EANNA_06927" "EANNA_07105" "EANNA_07180" "EANNA_07185" "EANNA_07406" "EANNA_07536" "EANNA_07968" "EANNA_08282" "EANNA_08398" "EANNA_08806" "EANNA_08984" "EANNA_09121" "EANNA_09231" "EANNA_09260" "EANNA_09286" "EANNA_09432" "EANNA_09601" "EANNA_09727" "EANNA_0973" "EANNA_09748" "EANNA_09791" "EANNA_09934" {
replace a77_o=1 if nna_selec==1 & folio=="`i'"  
 }
*gen a77_ab =1 if nna_selec==1 & inlist(folio,"") //no aplica
gen a77_as =1 if nna_selec==1 & inlist(folio,"EANNA_015580","EANNA_017465","EANNA_0263","EANNA_05780","EANNA_08814")
*gen a77_vb =1 if nna_selec==1 & inlist(folio,"") //no aplica
gen a77_vs =1 if nna_selec==1 & inlist(folio,"EANNA_010700","EANNA_011545","EANNA_012196","EANNA_017290","EANNA_03624","EANNA_04117","EANNA_07058") 

*la revision de glosas permite identificar los siguientes casos como excepciones
gen excepto=. 
foreach i in "EANNA_011010" "EANNA_011076" "EANNA_01185" "EANNA_012620" "EANNA_012998" "EANNA_01307" "EANNA_014364" "EANNA_014522" "EANNA_01467" "EANNA_016760" "EANNA_017458" "EANNA_02515" "EANNA_03828" "EANNA_05229" "EANNA_06975" "EANNA_07113" "EANNA_0762" "EANNA_08327" "EANNA_09779" "EANNA_07009" {
replace excepto=1 if nna_selec==1 & folio=="`i'"
}
replace tt_e=0 if excepto==1 //para evitar excluir otras actividades que puedan realizar nna se modifica el tiempo

***********************************************************************
* REVISION glosa 77 modulo Actividades Economicas: definiendo forma de trabajo y excepciones (5 a 8)
***********************************************************************
gen n77_o  =1 if nna_selec==1 & inlist(folio,"EANNA_01233","EANNA_013179","EANNA_01619","EANNA_016719","EANNA_01984","EANNA_08729","EANNA_09169","EANNA_09170","EANNA_09738")
gen n77_ab =1 if nna_selec==1 & inlist(folio,"EANNA_01236")
gen n77_as =1 if nna_selec==1 & inlist(folio,"EANNA_010354","EANNA_03090")
*gen n77_vb =1 if nna_selec==1 & inlist(folio,"") //no aplica
gen n77_vs =1 if nna_selec==1 & inlist(folio,"EANNA_09120")
gen n77_exc=1 if nna_selec==1 & inlist(folio,"EANNA_016760","EANNA_017428")


***********************************************************************
* SECCION FORMAS DE TRABAJO: OCUPACION (9 a 17)
***********************************************************************
*Si realiza dos o más actividades en módulo AE y en actividades seleccionadas del modulo TH se registra actividad principal en a29a 
*FILTRO POR ACTIVIDAD PRINCIPAL [MODULO TH] - [orden dado por a29a] Fuera del hogar y recibe pago
gen 	o_principal=.
replace o_principal=1  if a14_1==1  & a29a==1 & a14_1_destino==2  & a14_1_pago==1  	//actividad a14_1
replace o_principal=5  if a14_5==1  & a29a==2 & a14_5_destino==2  & a14_5_pago==1  	//actividad a14_5
replace o_principal=6  if a14_6==1  & a29a==5 & a14_6_destino==2  & a14_6_pago==1  	//actividad a14_6
replace o_principal=7  if a14_7==1  & a29a==3 & a14_7_destino==2  & a14_7_pago==1  	//actividad a14_7
replace o_principal=11 if a14_11==1 & a29a==4 & a14_11_destino==2 & a14_11_pago==1 	//actividad a14_11
replace o_principal=12 if a14_12==1 & a29a==6 & a14_12_destino==2 & a14_12_pago==1 	//actividad a14_12
replace o_principal=76 if a14_77==1 & a29a==7 & a14_77_destino==2 & a14_77_pago==1 	//actividad a14_77
*FILTRO POR ACTIVIDAD PRINCIPAL [MODULO AE] - [orden dado por a29a] Fuera del hogar y recibe pago
replace o_principal=13 if a27_1==1  & a29a==8										//actividad a27_1
replace o_principal=14 if a27_2==1  & a29a==9										//actividad a27_2
replace o_principal=15 if a27_3==1  & a29a==10 & a27_3_destino==2  & a27_3_pago==1	//actividad a27_3
replace o_principal=16 if a27_4==1  & a29a==11										//actividad a27_4
replace o_principal=17 if a27_5==1  & a29a==12										//actividad a27_5
replace o_principal=18 if a27_6==1  & a29a==13										//actividad a27_6
replace o_principal=19 if a27_7==1  & a29a==14 & a27_7_destino==2  & a27_7_pago==1	//actividad a27_7
replace o_principal=20 if a27_8==1  & a29a==15 & a27_8_destino==2  & a27_8_pago==1	//actividad a27_8
replace o_principal=20 if a27_8==1  & a29a==15 & a27_8_destino==1  					//actividad a27_8
replace o_principal=21 if a27_9==1  & a29a==16 & a27_9_destino==2  & a27_9_pago==1	//actividad a27_9
replace o_principal=22 if a27_10==1 & a29a==17 & a27_10_destino==2 & a27_10_pago==1	//actividad a27_10
replace o_principal=23 if a27_11==1 & a29a==18 & a27_11_destino==2 & a27_11_pago==1	//actividad a27_11
replace o_principal=24 if a27_12==1 & a29a==19 & a27_12_destino==2 & a27_12_pago==1	//actividad a27_12
replace o_principal=25 if a29a==20 //quito filtro a27_13==1 para incorporar a29a 	//actividad a27_13
replace o_principal=77 if a27_77==1 & a29a==77 & a27_77_destino==2 & a27_77_pago==1	//actividad a27_77
replace o_principal=77 if a27_77==1 & a29a==77 & a77_o==1							//actividad a27_77 (revision glosas)
*FILTRO POR ACTIVIDAD UNICA [MODULO AE]
gen 	o_unica=.
replace o_unica=1 if a27_1==1  & a29a==.											//actividad a27_1
replace o_unica=1 if a27_2==1  & a29a==.											//actividad a27_2
replace o_unica=1 if a27_3==1  & a29a==. & a27_3_destino==2  & a27_3_pago==1		//actividad a27_3
replace o_unica=1 if a27_4==1  & a29a==.											//actividad a27_4
replace o_unica=1 if a27_5==1  & a29a==.											//actividad a27_5
replace o_unica=1 if a27_6==1  & a29a==.											//actividad a27_6
replace o_unica=1 if a27_7==1  & a29a==. & a27_7_destino==2  & a27_7_pago==1		//actividad a27_7
replace o_unica=1 if a27_8==1  & a29a==. & a27_8_destino==2  & a27_8_pago==1		//actividad a27_8
replace o_unica=1 if a27_8==1  & a29a==. & a27_8_destino==1 						//actividad a27_8
replace o_unica=1 if a27_9==1  & a29a==. & a27_9_destino==2  & a27_9_pago==1		//actividad a27_9
replace o_unica=1 if a27_10==1 & a29a==. & a27_10_destino==2 & a27_10_pago==1		//actividad a27_10
replace o_unica=1 if a27_11==1 & a29a==. & a27_11_destino==2 & a27_11_pago==1		//actividad a27_11
replace o_unica=1 if a27_12==1 & a29a==. & a27_12_destino==2 & a27_12_pago==1		//actividad a27_12
replace o_unica=1 if a27_13==1 & a29a==.											//actividad a27_13
replace o_unica=1 if a27_77==1 & a29a==. & a27_77_destino==2 & a27_77_pago==1		//actividad a27_77
replace o_unica=1 if a27_77==1 & a29a==. & a77_o==1									//actividad a27_77 (revision glosas)

*FILTRO POR MODULO UNICA [MODULO TH] 
gen 	o_a14=.
replace o_a14=1 if ((a14_1==1 & a14_1_destino==2 & a14_1_pago==1) |(a14_5==1 & a14_5_destino==2 & a14_5_pago==1) |(a14_6==1 & a14_6_destino==2 & a14_6_pago==1) |(a14_7==1 & a14_7_destino==2 & a14_7_pago==1) | ///
					(a14_11==1 &a14_11_destino==2 &a14_11_pago==1) |(a14_12==1 &a14_12_destino==2 &a14_12_pago==1) |(a14_77==1 &a14_77_destino==2 &a14_77_pago==1)) 

*INCORPORAR a28/
gen 	ausente=.
replace ausente=1 if a29b==4 & a28_1_4==1  //actividades directas en (principal) // hay dos a29b 4 y 77, la 77 es prepractica en taller mecanico 
replace ausente=1 if a29b==. & (a28_1_1==1 |a28_1_2==1 | a28_1_3==1 | a28_1_4==1 | a28_1_5==1 | a28_1_6==1 |a28_1_7==1 | a28_1_9==1 | a28_1_12==1 | a28_1_13==1 | a28_1_77==1) //actividades directas en ocupacion y bienes (unica)
replace ausente=0 if a29b==. & (a28_1_8==1 | a28_1_10==1| a28_1_11==1) //en 77 hay una practica (laboratorio electrónico) a28_1_esp="Laboratorio electrónico Cesmex práctica  profesional  de su educación profesional."

//como hay nna que realizan multiples actividades se identifica la categoria principal primero, luego la unica, ambas son excluyentes entre si y por tanto no importa el orden entre ellas, sin embargo, al incluir modulo tareas del hogar (TH) es necesario filtrar. Toma el valor 1 cuando proviene del modulo actividades economicas y 2 cuando proviene del modulo tareas del hogar, esto permite identificar si la actividad reportada contiene informacion de peligrosidad
*CREAR VARIABLE OCUPACION - realiza trabajo por una hora o mas
gen 	ocupacion=1 if (tt_e>=1 &tt_e!=.) 		  & inrange(o_principal,1,77) 				//actividad principal primero //valor 1 para categorizar segun peligrosidad
replace ocupacion=1 if (tt_e>=1 &tt_e!=.) 		  & o_unica==1   							//directo, no pasa por filtro a29a porque solo reporta una actividad economica
replace ocupacion=2 if (tt_h_ocu>=1 &tt_h_ocu!=.) & o_unica==. &o_principal==. &o_a14==1	//modulo TH(1,5,6,7,11,12,77) hay 1 caso que declara a29a que ira a autoconsumo servicios
replace ocupacion=1 if (tt_e>=1 &tt_e!=.)		  & ausente==1								//se incorpora trabajo al que volverá

***********************************************************************
* SECCION FORMAS DE TRABAJO: OCUPACION (5 a 8)
***********************************************************************
*FILTRO POR CADA ACTIVIDAD [MODULO AE] - Fuera del hogar y recibe pago 
replace o_principal=13 if n17_1==1  & n19==1										//actividad n17_1
replace o_principal=14 if n17_2==1  & n19==2										//actividad n17_2
replace o_principal=15 if n17_3==1  & n19==3 & n17_3_destino==2  & n17_3_pago==1	//actividad n17_3
replace o_principal=16 if n17_4==1  & n19==4										//actividad n17_4
replace o_principal=17 if n17_5==1  & n19==5										//actividad n17_5
replace o_principal=18 if n17_6==1  & n19==6										//actividad n17_6
replace o_principal=19 if n17_7==1  & n19==7 & n17_7_destino==2  & n17_7_pago==1	//actividad n17_7
replace o_principal=20 if n17_8==1  & n19==8 & n17_8_destino==2  & n17_8_pago==1	//actividad n17_8
replace o_principal=20 if n17_8==1  & n19==8 & n17_8_destino==1 					//actividad n17_8
replace o_principal=21 if n17_9==1  & n19==9 & n17_9_destino==2  & n17_9_pago==1	//actividad n17_9
replace o_principal=22 if n17_10==1 & n19==10 & n17_10_destino==2 & n17_10_pago==1	//actividad n17_10
replace o_principal=23 if n17_11==1 & n19==11 & n17_11_destino==2 & n17_11_pago==1	//actividad n17_11
replace o_principal=24 if n17_12==1 & n19==12 & n17_12_destino==2 & n17_12_pago==1	//actividad n17_12
replace o_principal=25 if n17_13==1 & n19==13										//actividad n17_13
replace o_principal=77 if n17_77==1 & n19==77 & n17_77_destino==2 & n17_77_pago==1 	//actividad n17_77

*trabajo ocupacion
egen actividad_en=anycount(n17_1 n17_2 n17_3 n17_4 n17_5 n17_6 n17_7 n17_8 n17_9 n17_10 n17_11 n17_12 n17_13 n17_77) if nna_selec==1 & edad_grupo==1, v(1)
gen actividad_o=0 if nna_selec==1 //SOLO MODULO ACTIVIDADES ECONOMICAS
replace actividad_o=1 if nna_selec==1 & edad_grupo==1 & (n17_1==1 |n17_2==1 |n17_4==1 |n17_5==1 |n17_6==1 |n17_13==1)  //AE directo
replace actividad_o=1 if nna_selec==1 & edad_grupo==1 & ((n17_3==1 &n17_3_destino==2 &n17_3_pago==1) | (n17_7==1 &n17_7_destino==2 &n17_7_pago==1) | (n17_8==1 &n17_8_destino==2 &n17_8_pago==1) | (n17_8==1 &n17_8_destino==1) ///
														  | (n17_9==1 &n17_9_destino==2 &n17_9_pago==1) | (n17_10==1 &n17_10_destino==2 &n17_10_pago==1) | (n17_11==1 &n17_11_destino==2 &n17_11_pago==1) ///
														  | (n17_12==1 &n17_12_destino==2 &n17_12_pago==1) |(n17_77==1 &n17_77_destino==2 &n17_77_pago==1)) //AE fuera del hogar y recibe pago
*VARIABLE OCUPACION - SIN FILTRO TIEMPO
replace ocupacion=1 if inrange(o_principal,13,77) & edad_grupo==1			//actividad principal
replace ocupacion=1 if actividad_o==1 & actividad_en==1	& edad_grupo==1		//directo, no pasa por filtro n19 porque solo reporta una actividad



***********************************************************************
* SECCION FORMAS DE TRABAJO: AUTOCONSUMO (DE BIENES) (9 a 17)
***********************************************************************
*Si realiza dos o más actividades en módulo AE y en actividades seleccionadas del modulo TH se registra actividad principal en a29a 
*FILTRO POR ACTIVIDAD PRINCIPAL [MODULO TH] - [orden dado por a29a] DENTRO DEL HOGAR
gen 	ab_principal=.
replace ab_principal=6 if a14_6==1  & a29a==5 & a14_6_destino==1	//actividad a14_6
replace ab_principal=11 if a14_11==1 & a29a==4 & a14_11_destino==1	//actividad a14_11
replace ab_principal=12 if a14_12==1 & a29a==6 & a14_12_destino==1	//actividad a14_12
*FILTRO POR CADA ACTIVIDAD [MODULO AE] - DENTRO DEL HOGAR	
replace ab_principal=15 if a27_3==1  & a29a==10 & a27_3_destino==1	//actividad a27_3
replace ab_principal=19 if a27_7==1  & a29a==14 & a27_7_destino==1	//actividad a27_7
replace ab_principal=21 if a27_9==1  & a29a==16 & a27_9_destino==1	//actividad a27_9
replace ab_principal=24 if a27_12==1 & a29a==19 & a27_12_destino==1	//actividad a27_12

*FILTRO POR ACTIVIDAD UNICA [MODULO AE]
gen 	ab_unica=.
replace ab_unica=1 if a27_3==1  & a29a==. & a27_3_destino==1  		//actividad a27_3
replace ab_unica=1 if a27_7==1  & a29a==. & a27_7_destino==1  		//actividad a27_7
replace ab_unica=1 if a27_9==1  & a29a==. & a27_9_destino==1 		//actividad a27_9
replace ab_unica=1 if a27_12==1 & a29a==. & a27_12_destino==1 		//actividad a27_12

*FILTRO POR MODULO TH
gen 	ab_a14=.
replace ab_a14=1 if ((a14_6==1 &a14_6_destino==1) | (a14_11==1 &a14_11_destino==1) | (a14_12==1 &a14_12_destino==1)) //TH DENTRO DEL HOGAR

//como hay nna que realizan multiples actividades se identifica la categoria principal primero, luego la unica, ambas son excluyentes entre si y por tanto no importa el orden entre ellas, sin embargo, al incluir modulo tareas del hogar (TH) es necesario filtrar. Toma el valor 1 cuando proviene del modulo actividades economicas y 2 cuando proviene del modulo tareas del hogar, esto permite identificar si la actividad reportada contiene informacion de peligrosidad
*CREAR VARIABLE AUTOCONSUMO BIENES - realiza trabajo por una hora o mas 
gen 	autoconsumo_b=1 if (tt_e>=1 &tt_e!=.)			& inrange(ab_principal,1,77)													//actividad principal primero //valor 1 para categorizar segun peligrosidad
replace autoconsumo_b=1 if (tt_e>=1 &tt_e!=.) 			& ab_unica==1																	//directo, no pasa por filtro a29a porque solo reporta una actividad economica
replace autoconsumo_b=2 if (tt_h_autb>=1 &tt_h_autb!=.) & ab_unica==. & ab_principal==. &ab_a14==1 										//modulo TH(6,11,12) 
replace autoconsumo_b=2 if (tt_h_autb>=1 &tt_h_autb!=.) & ab_unica==. & ab_principal==. &a14_77==1 &a14_77_destino==1 & th77_ab==1		//se incorpora casos 77

***********************************************************************
* SECCION FORMAS DE TRABAJO: AUTOCONSUMO (DE BIENES) (5 a 8)
***********************************************************************
*FILTRO POR ACTIVIDAD PRINCIPAL [MODULO AE] - [orden dado por n19] DENTRO DEL HOGAR
replace ab_principal=15 if n17_3==1  & n19==3 & n17_3_destino==1	//actividad n17_3
replace ab_principal=19 if n17_7==1  & n19==7 & n17_7_destino==1	//actividad n17_7
replace ab_principal=21 if n17_9==1  & n19==9 & n17_9_destino==1	//actividad n17_9
replace ab_principal=24 if n17_12==1 & n19==12 & n17_12_destino==1	//actividad n17_12
replace ab_principal=77 if n17_77==1 & n19==77 & n17_77_destino==1 	//actividad n17_77

*trabajo autoconsumo BIENES
gen			actividad_ab=0 if nna_selec==1
replace 	actividad_ab=1 if nna_selec==1 & edad_grupo==1 & ((n17_3==1 &n17_3_destino==1) |(n17_7==1 &n17_7_destino==1 ) |(n17_9==1 &n17_9_destino==1) |(n17_12==1 &n17_12_destino==1)) // AE DENTRO DEL HOGAR - se incorporan glosas 77 posteriormente (linea 356)

*VARIABLE AUTOCONSUMO - SIN FILTRO TIEMPO 
replace autoconsumo_b=1 if inrange(ab_principal,13,77) & edad_grupo==1 										//actividad principal 
replace autoconsumo_b=1 if actividad_ab==1 & actividad_en==1 & edad_grupo==1								//directo, no pasa por filtro n19 porque solo reporta una actividad
replace autoconsumo_b=1 if nna_selec==1 & actividad_en==1 & edad_grupo==1 & (n17_77==1 &n17_77_destino==1)	//incorporo n17_77 que realizan unica actividad, se incorporan glosas 77 posteriormente  (linea 356)



***********************************************************************
* SECCION FORMAS DE TRABAJO: VOLUNTARIO (DE BIENES) (9 a 17)
***********************************************************************
*Si realiza dos o más actividades en módulo AE y en actividades seleccionadas del modulo TH se registra actividad principal en a29a 
*FILTRO POR ACTIVIDAD PRINCIPAL [MODULO TH] - [orden dado por a29a] FUERA DEL HOGAR Y SIN PAGO
gen 	vb_principal=.
replace vb_principal=5 if a14_6==1  & a29a==5 & a14_6_destino==2  & a14_6_pago==2		//actividad a14_6
replace vb_principal=4 if a14_11==1 & a29a==4 & a14_11_destino==2 & a14_11_pago==2		//actividad a14_11
replace vb_principal=6 if a14_12==1 & a29a==6 & a14_12_destino==2 & a14_12_pago==2		//actividad a14_12
*FILTRO POR CADA ACTIVIDAD [MODULO AE] - FUERA DEL HOGAR Y SIN PAGO - se incorpora glosas 77 posteriormente  (linea 232)
replace vb_principal=10 if a27_3==1  & a29a==10 & a27_3_destino==2  & a27_3_pago==2		//actividad a27_3
replace vb_principal=14 if a27_7==1  & a29a==14 & a27_7_destino==2  & a27_7_pago==2		//actividad a27_7
replace vb_principal=16 if a27_9==1  & a29a==16 & a27_9_destino==2  & a27_9_pago==2		//actividad a27_9
replace vb_principal=19 if a27_12==1 & a29a==19 & a27_12_destino==2 & a27_12_pago==2	//actividad a27_12

*FILTRO POR ACTIVIDAD UNICA [MODULO AE]
gen 	vb_unica=.
replace vb_unica=1 if a27_3==1  & a29a==. & a27_3_destino==2  & a27_3_pago==2			//actividad a27_3
replace vb_unica=1 if a27_7==1  & a29a==. & a27_7_destino==2  & a27_7_pago==2			//actividad a27_7
replace vb_unica=1 if a27_9==1  & a29a==. & a27_9_destino==2  & a27_9_pago==2			//actividad a27_9
replace vb_unica=1 if a27_12==1 & a29a==. & a27_12_destino==2 & a27_12_pago==2			//actividad a27_12
*FILTRO POR MODULO TH
gen 	vb_a14=.
replace vb_a14=1 if ((a14_6==1 & a14_6_destino==2 & a14_6_pago==2) |(a14_11==1 &a14_11_destino==2 &a14_11_pago==2) |(a14_12==1 &a14_12_destino==2 &a14_12_pago==2)) //TH FUERA DEL HOGAR Y SIN PAGO

//como hay nna que realizan multiples actividades se identifica la categoria principal primero, luego la unica, ambas son excluyentes entre si y por tanto no importa el orden entre ellas, sin embargo, al incluir modulo tareas del hogar (TH) es necesario filtrar. Toma el valor 1 cuando proviene del modulo actividades economicas y 2 cuando proviene del modulo tareas del hogar, esto permite identificar si la actividad reportada contiene informacion de peligrosidad
*CREAR VARIABLE VOLUNTARIO BIENES- realiza trabajo por una hora o mas 
gen 	voluntario_b=1 if (tt_e>=1 &tt_e!=.)			& inrange(vb_principal,1,77)													//actividad principal primero //valor 1 para categorizar segun peligrosidad
replace voluntario_b=1 if (tt_e>=1 &tt_e!=.)			& vb_unica==1																	//directo, no pasa por filtro a29a porque solo reporta una actividad economica
replace voluntario_b=2 if (tt_h_volb>=1 &tt_h_volb!=.)  & vb_unica==. & vb_principal==. &vb_a14==1  									//modulo TH(6,11,12,77)
replace voluntario_b=2 if (tt_h_volb>=1 &tt_h_volb!=.)  & vb_unica==. & vb_principal==. &a14_77==1 &a14_77_destino==2 &a14_77_pago==2 	//se incorpora casos 77

***********************************************************************
* SECCION FORMAS DE TRABAJO: VOLUNTARIO (DE BIENES) (5 a 8)
***********************************************************************
*FILTRO POR CADA ACTIVIDAD [MODULO AE] - [orden dado por n19] FUERA DEL HOGAR Y SIN PAGO
replace vb_principal=15 if n17_3==1  & n19==3 & n17_3_destino==2  & n17_3_pago==2	//actividad n17_3
replace vb_principal=19 if n17_7==1  & n19==7 & n17_7_destino==2  & n17_7_pago==2	//actividad n17_7
replace vb_principal=21 if n17_9==1  & n19==9 & n17_9_destino==2  & n17_9_pago==2	//actividad n17_9
replace vb_principal=24 if n17_12==1 & n19==12 & n17_12_destino==2 & n17_12_pago==2	//actividad n17_12
replace vb_principal=77 if n17_77==1 & n19==77 & n17_77_destino==2 & n17_77_pago==2	//actividad n17_77

*trabajo voluntario BIENES
gen		actividad_vb=0 if nna_selec==1
replace actividad_vb=1 if nna_selec==1 & edad_grupo==1 & ((n17_3==1 &n17_3_destino==2 &n17_3_pago==2) |(n17_7==1 &n17_7_destino==2 &n17_7_pago==2) |(n17_9==1 &n17_9_destino==2 &n17_9_pago==2) ///
															|(n17_12==1 &n17_12_destino==2 &n17_12_pago==2))  //AE FUERA DEL HOGAR Y SIN PAGO

*VARIABLE VOLUNTARIO - SIN FILTRO TIEMPO 
replace voluntario_b=1 if inrange(vb_principal,13,77) & edad_grupo==1 														//actividad principal 
replace voluntario_b=1 if actividad_vb==1 & actividad_en==1 & edad_grupo==1													//directo, no pasa por filtro n19 porque solo reporta una actividad
replace voluntario_b=1 if nna_selec==1 & actividad_en==1 & edad_grupo==1 & (n17_77==1 &n17_77_destino==2 & n17_77_pago==2)	//incorporo n17_77 que realizan unica actividad, en siguiente seccion se se hace revision de glosas 77  



***********************************************************************
* SECCION FORMAS DE TRABAJO: AUTCONSUMO (DE SERVICIOS) (9 a 17)
***********************************************************************
*Si realiza dos o más actividades en módulo AE y en actividades seleccionadas del modulo TH se registra actividad principal en a29a 
*FILTRO POR ACTIVIDAD PRINCIPAL [MODULO TH] - [orden dado por a29a] DENTRO DEL HOGAR
gen 	as_principal=.
replace as_principal=1 if a14_1==1  & a29a==1 & a14_1_destino==1  	//actividad a14_1
replace as_principal=5 if a14_5==1  & a29a==2 & a14_5_destino==1	//actividad a14_5
replace as_principal=7 if a14_7==1  & a29a==3 & a14_7_destino==1	//actividad a14_7
*FILTRO POR CADA ACTIVIDAD [MODULO AE] - DENTRO DEL HOGAR
replace as_principal=22 if a27_10==1 & a29a==17 & a27_10_destino==1	//actividad a27_10
replace as_principal=23 if a27_11==1 & a29a==18 & a27_11_destino==1	//actividad a27_11
replace as_principal=76 if (tt_e>=1 &tt_e!=.) 	& ausente==0		//trabajo al que volver
replace as_principal=77 if a27_77==1 & a29a==77 & a77_as==1			//actividad a27_77 (revision glosas)
*FILTRO POR ACTIVIDAD UNICA [MODULO AE]
gen 	as_unica=.
replace as_unica=1 if a27_10==1 & a29a==. & a27_10_destino==1 		//actividad a27_10
replace as_unica=1 if a27_11==1 & a29a==. & a27_11_destino==1 		//actividad a27_11
replace as_unica=1 if a27_77==1 & a29a==. & a77_as==1 				//actividad a27_77 (revision glosas)

*FILTRO POR MODULO TH
gen 	as_a14=.
replace as_a14=1 if ((a14_1==1 & a14_1_destino==1) |(a14_5==1 &a14_5_destino==1) |(a14_7==1 &a14_7_destino==1) |a14_2==1 |a14_3==1 |a14_4==1 |a14_8==1 |a14_9==1 |a14_10==1) //TH DENTRO DEL HOGAR

//como hay nna que realizan multiples actividades se identifica la categoria principal primero, luego la unica, ambas son excluyentes entre si y por tanto no importa el orden entre ellas, sin embargo, al incluir modulo tareas del hogar (TH) es necesario filtrar. Toma el valor 1 cuando proviene del modulo actividades economicas y 2 cuando proviene del modulo tareas del hogar, esto permite identificar si la actividad reportada contiene informacion de peligrosidad
*CREAR VARIABLE AUTCONSUMO SERVICIOS - realiza trabajo por una hora o mas 
gen 	autoconsumo_s=1 if (tt_e>=1 &tt_e!=.)			 & inrange(as_principal,1,77)   								//actividad principal primero //valor 1 para categorizar segun peligrosidad
replace autoconsumo_s=1 if (tt_e>=1 &tt_e!=.)			 & as_unica==1													//directo, no pasa por filtro a29a porque solo reporta una actividad economica
replace autoconsumo_s=2 if (tt_h_auts>=1 & tt_h_auts!=.) & autoconsumo_s==.  &as_a14==1  								//modulo TH(2,3,4,8,9,10 y 1,5,7)
replace autoconsumo_s=2 if (tt_h_auts>=1 & tt_h_auts!=.) & autoconsumo_s==.  &a14_77==1 &a14_77_destino==1 & th77_as==1 //se incorpora casos 77

***********************************************************************
* SECCION FORMAS DE TRABAJO: AUTCONSUMO (DE SERVICIOS) (5 a 8)
***********************************************************************
*FILTRO POR CADA ACTIVIDAD [MODULO AE] - [orden dado por n19] - DENTRO DEL HOGAR
replace as_principal=22 if n17_10==1 & n19==10 & n17_10_destino==1	//actividad a27_10
replace as_principal=23 if n17_11==1 & n19==11 & n17_11_destino==1	//actividad a27_11

*trabajo autoconsumo SERVICIOS
gen		actividad_as=0 if nna_selec==1
replace actividad_as=1 if nna_selec==1 & edad_grupo==1 & ((n17_8==1 &n17_8_destino==1) |(n17_10==1 &n17_10_destino==1) |(n17_11==1 &n17_11_destino==1))  //AE DENTRO DEL HOGAR 

*VARIABLE AUTCONSUMO Y VOLUNTARIO DE SERVICIOS 
replace autoconsumo_s=1 if inrange(as_principal,13,77) & edad_grupo==1 			//actividad principal 
replace autoconsumo_s=1 if actividad_as==1 & actividad_en==1 & edad_grupo==1	//directo, no pasa por filtro n19 porque solo reporta una actividad



***********************************************************************
* SECCION FORMAS DE TRABAJO: VOLUNTARIO (DE SERVICIOS) (9 a 17)
***********************************************************************
*Si realiza dos o más actividades en módulo AE y en actividades seleccionadas del modulo TH se registra actividad principal en a29a 
*FILTRO POR ACTIVIDAD PRINCIPAL [MODULO TH] - [orden dado por a29a] FUERA DEL HOGAR Y SIN PAGO
gen 	vs_principal=.
replace vs_principal=1 if a14_1==1  & a29a==1 & a14_1_destino==2  & a14_1_pago==2		//actividad a14_1
replace vs_principal=2 if a14_5==1  & a29a==2 & a14_5_destino==2  & a14_5_pago==2		//actividad a14_5
replace vs_principal=3 if a14_7==1  & a29a==3 & a14_7_destino==2  & a14_7_pago==2		//actividad a14_7
*FILTRO POR CADA ACTIVIDAD [MODULO AE] - FUERA DEL HOGAR Y SIN PAGO
replace vs_principal=15 if a27_8==1  & a29a==15 & a27_8_destino==2  & a27_8_pago==2		//actividad a27_8
replace vs_principal=17 if a27_10==1 & a29a==17 & a27_10_destino==2 & a27_10_pago==2	//actividad a27_10
replace vs_principal=18 if a27_11==1 & a29a==18 & a27_11_destino==2 & a27_11_pago==2	//actividad a27_11
replace vs_principal=77 if a27_77==1 & a29a==77 & a77_vs==1								//actividad a27_77 (revision glosas)

*FILTRO POR ACTIVIDAD UNICA [MODULO AE]
gen 	vs_unica=.
replace vs_unica=1 if a27_8==1  & a29a==. & a27_8_destino==2  & a27_8_pago==2			//actividad a27_8
replace vs_unica=1 if a27_10==1 & a29a==. & a27_10_destino==2 & a27_10_pago==2			//actividad a27_10
replace vs_unica=1 if a27_11==1 & a29a==. & a27_11_destino==2 & a27_11_pago==2			//actividad a27_11
replace vs_unica=1 if a27_77==1 & a29a==. & a77_vs==1									//actividad a27_77 (revision glosas)

*FILTRO POR MODULO TH
gen 	vs_a14=.
replace vs_a14=1 if (a14_1==1 & a14_1_destino==2 & a14_1_pago==2) |(a14_5==1 &a14_5_destino==2 & a14_5_pago==2) |(a14_7==1 &a14_7_destino==2 & a14_7_pago==2) //AE FUERA DEL HOGAR Y SIN PAGO

*CREAR VARIABLE VOLUNTARIO SERVICIOS - realiza trabajo por una hora o mas 
gen 	voluntario_s=1 if (tt_e>=1 &tt_e!=.)			& inrange(vs_principal,1,77)									//actividad principal primero //valor 1 para categorizar segun peligrosidad
replace voluntario_s=1 if (tt_e>=1 &tt_e!=.)			& vs_unica==1													//directo, no pasa por filtro a29a porque solo reporta una actividad economica
replace voluntario_s=2 if (tt_h_vols>=1 & tt_h_vols!=.)	& voluntario_s==. &vs_a14==1  									//modulo TH(1,5,7)
replace voluntario_s=2 if (tt_h_vols>=1 & tt_h_vols!=.) & voluntario_s==. &a14_77==1 &a14_77_destino==2 &a14_77_pago==2	//se incorpora casos 77

***********************************************************************
* SECCION FORMAS DE TRABAJO: VOLUNTARIO (DE SERVICIOS) (5 a 8)
***********************************************************************
*FILTRO POR CADA ACTIVIDAD [MODULO AE] - FUERA DEL HOGAR Y SIN PAGO
replace vs_principal=20 if n17_8==1  & n19==8 & n17_8_destino==2  & n17_8_pago==2	//actividad n17_8
replace vs_principal=22 if n17_10==1 & n19==10 & n17_10_destino==2 & n17_10_pago==2	//actividad n17_10
replace vs_principal=23 if n17_11==1 & n19==11 & n17_11_destino==2 & n17_11_pago==2	//actividad n17_11

*trabajo voluntario SERVICIOS
gen		actividad_vs=0 if nna_selec==1
replace	actividad_vs=1 if nna_selec==1 & edad_grupo==1 & ((n17_8==1 &n17_8_destino==2 & n17_8_pago==2) |(n17_10==1 &n17_10_destino==2 &n17_10_pago==2) ///
															|(n17_11==1 &n17_11_destino==2 &n17_11_pago==2))  //AE FUERA DEL HOGAR Y SIN PAGO

*CREAR VARIABLE VOLUNTARIO SERVICIOS - SIN FILTRO TIEMPO 
replace voluntario_s=1 if inrange(vs_principal,13,77) & edad_grupo==1 		//actividad principal 
replace voluntario_s=1 if actividad_vs==1 & actividad_en==1 & edad_grupo==1	//directo, no pasa por filtro n19 porque solo reporta una actividad



***********************************************************************
* Ajuste por revision 77 (5 a 8)
***********************************************************************
replace ocupacion=0   if n77_exc==1 | n77_ab==1 | n77_as==1 | n77_vs==1
replace ocupacion=1   if n77_o==1

replace autoconsumo_b=0   if n77_exc==1 | n77_o==1 | n77_as==1 | n77_vs==1
replace autoconsumo_b=1   if n77_ab==1

replace voluntario_b=0    if n77_exc==1 | n77_o==1 | n77_as==1 | n77_vs==1 | n77_ab==1
*replace voluntario_b=1   if n77_vb==1 //no aplica

replace autoconsumo_s=0   if n77_exc==1 | n77_o==1 | n77_vs==1 | n77_ab==1
replace autoconsumo_s=1   if n77_as==1

replace voluntario_s=0   if n77_exc==1 | n77_o==1 | n77_as==1 | n77_ab==1
replace voluntario_s=1   if n77_vs==1

***********************************************************************
* SECCION FORMAS DE TRABAJO: TRABAJO NO REMUNERADO (DE SERVICIOS)
***********************************************************************
*Hace una actividad del hogar tsnr -  MODULO TAREAS DEL HOGAR (5 a 8)
gen actividad_th=(n11_1==1 |n11_2==1 |n11_3==1 |n11_4==1 |n11_5==1 |n11_6==1 |n11_7==1 |n11_8==1 |n11_9==1 |n11_10==1 |n11_11==1 |n11_12==1) if nna_selec==1 

*CREAR VARIABLE TNR SERVICIOS - realiza trabajo por una hora o mas (9 a 17)
gen 	tsnr1=1 if (tt_e>=1 &tt_e!=.)			& inrange(as_principal,1,77)																//actividad principal primero //valor 1 para categorizar segun peligrosidad
replace	tsnr1=1 if (tt_e>=1 &tt_e!=.)			& inrange(vs_principal,1,77)																//actividad principal primero //valor 1 para categorizar segun peligrosidad
replace tsnr1=1 if (tt_e>=1 &tt_e!=.)			& as_unica==1																				//directo, solo modulo TH (autoconsumo de servicios)
replace tsnr1=1 if (tt_e>=1 &tt_e!=.)			& vs_unica==1																				//directo, solo modulo TH (voluntario de servicios)
egen 	tt_tsnr=rsum(tt_e tt_h_tsnr) 			if (inrange(as_principal,1,77) | inrange(vs_principal,1,77) | as_unica==1 | vs_unica==1)	//suma tiempos AE y TH
gen		tsnr2=1 if (tt_tsnr>=1 &tt_tsnr!=.) 																								//actividad principal primero //valor 1 para categorizar segun peligrosidad
replace	tsnr2=1 if (tt_h_tsnr>=1 & tt_h_tsnr!=.)&(as_a14==1 | vs_a14==1)																	//directo, solo modulo TH (autoconsumo y voluntario de servicios)
replace tsnr2=1 if (tt_h_tsnr>=1 & tt_h_tsnr!=.)& a14_77==1 & a14_77_destino==1 & th77_as==1 												//77 modulo TH autoconsumo de servicios 
replace tsnr2=1 if (tt_h_tsnr>=1 & tt_h_tsnr!=.)& a14_77==1 & a14_77_destino==2 & a14_77_pago==2 											//77 modulo TH voluntario de servicios 
replace tsnr2=1 if (tt_cocina>=1 & tt_cocina!=.)& tsnr2==.																					//modulo TH cocina


